/*
 * CalendarServer.java
 *
 * Created on November 9, 2004, 10:34 AM
 */
package dop;

import java.util.*;
import java.rmi.*;
import java.rmi.server.*;

//A remote object implementation should implement the Unreferenced interface to receive notification when there are no more clients that reference that remote object.

/**
 *
 * @author  garbi
 */
public class CalendarServer extends UnicastRemoteObject implements CalendarService, Unreferenced {

    private Hashtable calendars;

    /** Creates a new instance of CalendarServer */
    public CalendarServer() throws RemoteException {
        calendars = new Hashtable();//this hashtable will contain DayCalendar objects.
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

        try {
            java.rmi.registry.LocateRegistry.createRegistry(1099);//Creates and exports a Registry instance on the local host that accepts requests on the specified port. 1099 is the default port for RMI registery.
            System.out.println("RMI registry ready.");
        } catch (Exception e) {
            System.out.println("Exception starting RMI registry:");
            e.printStackTrace();
        }
        
        Naming.rebind("//localhost:1099/Calendar", new CalendarServer());
        

        //RemoteServer.setLog(System.out);
    }

    public DayCalendar createCalendar(String name) throws RemoteException, CalendarException {
        if (calendars.containsKey(name)) {
            throw new CalendarException("Calendar \"" + name + "\" already exists.");
        }
        DayCalendar newCal = new DayCalendarImpl(name);
        calendars.put(name, newCal);
        return newCal;
    }

    public DayCalendar getCalendar(String name) throws RemoteException, CalendarException {
        if (!calendars.containsKey(name)) {
            throw new CalendarException("Calendar \"" + name + "\" does not exist.");
        }
        return ((DayCalendar) calendars.get(name));
    }

    public ArrayList getCalendars() throws RemoteException {
        return new ArrayList(calendars.values());
    }

    public boolean exists(String name) throws RemoteException {
        return calendars.containsKey(name);
    }

    public void removeCalendar(String name) throws RemoteException {
        calendars.remove(name);
        System.out.println("In removeCalendar method of CalendarServer calss -> " + name + " was removed from the CalendarServer's hashtable.");
        System.gc();
    }

    public void unreferenced() {
        System.out.println("In unreferenced method of CalendarServer calss-> Oups, *the* Calendar server is no longer remotely referenced!");
    }
}
